/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.psg.dev.ui;

import frc.emul.psg.dev.AbstractSamplesProcessor;

public class SamplesProcessor
extends AbstractSamplesProcessor {
    public static final int DEFAULT_HISTORY_SIZE = 300;
    protected int[] listABC;
    protected int[] listA;
    protected int[] listB;
    protected int[] listC;
    protected int[] lMaxABC;
    protected int[] lMaxA;
    protected int[] lMaxB;
    protected int[] lMaxC;
    protected int writeIdx;
    protected boolean full;
    private boolean mute;

    public SamplesProcessor() {
        super(400);
        this.setHistorySize(300);
    }

    public SamplesProcessor(int n) {
        this.setHistorySize(Math.max(2, n));
    }

    public void reset() {
        this.setHistorySize(this.getHistorySize());
    }

    public int getHistorySize() {
        return this.listA == null ? 0 : this.listA.length;
    }

    public synchronized void setHistorySize(int n) {
        if (this.getHistorySize() != n) {
            this.listABC = new int[n];
            this.listA = new int[n];
            this.listB = new int[n];
            this.listC = new int[n];
            this.lMaxABC = new int[n];
            this.lMaxA = new int[n];
            this.lMaxB = new int[n];
            this.lMaxC = new int[n];
        }
        this.writeIdx = 0;
        this.full = false;
    }

    public final boolean isMute() {
        return this.mute;
    }

    public final void setMute(boolean bl) {
        if (bl != this.mute) {
            this.mute = bl;
            if (bl) {
                this.reset();
            }
        }
    }

    protected synchronized void processData() {
        int n = this.writeIdx;
        this.lMaxABC[n] = this.maxABC;
        this.lMaxA[n] = this.maxA;
        this.lMaxB[n] = this.maxB;
        this.lMaxC[n] = this.maxC;
        this.listABC[n] = this.accuABC;
        this.listA[n] = this.accuA;
        this.listB[n] = this.accuB;
        this.listC[n++] = this.accuC;
        if (n >= this.listA.length) {
            this.full = true;
            this.writeIdx = 0;
        } else {
            this.writeIdx = n;
        }
    }
}

